clear all;
load bathy;

lon_range=[-.5 .5];
lat_range=[5 6];

lon_range=[-5 5];
lat_range=[0 10];

figure;
m_proj('Mercator','lon',lon_range,'lat',lat_range);
m_pcolor(bathy.lon,bathy.lat,bathy.z); shading flat; hold on;
m_gshhs_h('patch',[.5 .5 .5]);

m_grid('box','fancy');
cb=colorbar;
cb.Label.String='depth (m)';

% Here we are making a cell with the times and locations of the CTD
% profiles

ctd.time=[datenum(2017,08,01,11,5,0) datenum(2017,08,01,11,25,0) datenum(2017,08,01,11,43,0)];
ctd.lat=[5.586 5.553 5.5243];
ctd.lon=[0.007 0.025 0.041];

m_plot(ctd.lon,ctd.lat,'kp','markerfacecolor','r','markersize',14)

% Here we are loading and plotting the conductivity, temperature, and depth of one
% profile

load ctd;

figure;
plot(time,pressure,'k','linewidth',2);
ylabel('pressure (dbar)');
datetick('x');
set(gca,'fontsize',14);

% Now let's select the down profile and plot conductivity and temperature 

[x,y]=ginput(2);

indices=find(time>x(1) & time<x(2));

figure;
subplot(1,2,1)
plot(temperature(indices),pressure(indices),'k','linewidth',2);
ylabel('pressure (dbar)');
xlabel('temperature (deg C)');
set(gca,'fontsize',14);
axis ij;

subplot(1,2,2)
plot(conductivity(indices),pressure(indices),'k','linewidth',2);
xlabel('conductivity (mS/cm)');
set(gca,'fontsize',14);
axis ij;


