%Drifter plotting


%load drifter

%place the drifter observations on the maps

figure(1998); clf
lon_range=[-.5 .5];
lat_range=[5 6];

% lon_range=[-5 5];
% lat_range=[0 10];


m_proj('Mercator','lon',lon_range,'lat',lat_range);
m_plot(drifter.lon,drifter.lat,'s')
m_gshhs_h('patch',[.5 .5 .5]);

m_grid('box','fancy');

%%

% Now let's calculate speed
% speed = (change in dist)/(change in time) [m/s]

time_sec=(drifter.time-drifter.time(1))*86400; %change matlab time to time in seconds since first measurements
time_difference=diff(time_sec);

distances=m_lldist(drifter.lon,drifter.lat)*1000; %use matlab to calculate distances between each drifter position in meters

speeds=distances./time_difference;
time_h=time_sec(2:end)/3600;

figure(99); clf
plot(time_h,speeds)
ylabel('speed (m/s)')
xlabel('time (h)')
title('Drifter speed')

%%

xlim([0 2]) %look at the beginning of the record

%What is going on here?

%%
%What is the average drift speed?

nanmean(speeds(time_h>2))

%What is the variability of drift speed?

nanstd(speeds(time_h>2))

%%

xlim([2 50]) %look at the rest of the record

%What is going on here?


