clear all;
load bathy;
[dday,yr,mth,d,hr,m,lat,lon,dpth]=load_tug();
% Add 4 m to the depths since transducer is 4 m below water line
dpth=dpth+4;
% Range of latitudes covered much bigger than range of longitudes
lat_lim=[min(lat) max(lat)]; 
lon_lim=[min(lon) max(lon)];
% find mid point of lat and lon covered
lat_ave=mean(lat_lim);
lon_ave=mean(lon_lim);
% find range of latitude
lat_rng=lat_lim(2)-lat_lim(1);
% Want the plot to cover a larger area than the data
% Since latitude range was greater, expand both by 1/6 
% of the latitude range
lat_ex=(lat_lim(2)-lat_lim(1))/6;
lon_ex=(lon_lim(2)-lon_lim(1))/6;
lon_range=[lon_ave-0.5*lat_rng-lat_ex lon_ave+0.5*lat_rng+lat_ex];
lat_range=[min(lat)-lat_ex max(lat)+lat_ex];

figure;
m_proj('Mercator','lon',lon_range,'lat',lat_range);
m_pcolor(bathy.lon,bathy.lat,bathy.z); shading flat; hold on;
m_gshhs_h('patch',[.5 .5 .5]);

m_grid('box','fancy');
colorbar;
%%
h=m_plot(lon,lat,'sk')
%%
print('-dpng','-r300','GhanaMap')

