function [dday,yr,mth,d,hr,min,lat,lon,dpth]=load_tug();
% Output (time in UTC)
% dday: matlab datenum
% yr: year
% mth: month
% d: day
% hr: hour 
% min: minute
% lat: latitude (decimal degrees)
% lon: longitude (decimal degrees)
% dpth: depth (m) 
fmt='%f-%f-%f %f:%f %f %f %f %f %f %s';
fid=fopen('tug.dat');
M=textscan(fid,fmt,'delimiter',',','emptyvalue',NaN);
M1=cell2mat(M(1:10));
dday=datenum([M1(:,1:5) 0*M1(:,1)]);
lat=M1(:,6)+M1(:,7)/60;
lon=M1(:,8)+M1(:,9)/60;
dpth=M1(:,10);
yr=M1(:,1);
mth=M1(:,2);
d=M1(:,3);
hr=M1(:,4);
min=M1(:,5);


