%plot seasonal anomalies
addpath(genpath('C:\Users\enyad\Documents\MATLAB\mytoolbox'));%for Hp laptop
clear;clc;
path1='C:\Users\enyad\Documents\NRL\SummerSch\RMU2017\lab\LabEx\';
outfile='C:\Users\enyad\Documents\NRL\SummerSch\RMU2017\lab\LabEx\';
%%%%%%%%%%%
grey=[0.8 0.8 0.8];ctime=1:12;
%%%%%%%%
%for int anom
data=load([path1 'ostia.atl.sst.nwgog.Jan93Dec15.TimeSeries.dat']);data=data(:,3:end);
jan=data(1:12:end,:);jan=nanmean(jan);feb=data(2:12:end,:);feb=nanmean(feb);
mar=data(3:12:end,:);mar=nanmean(mar);apr=data(4:12:end,:);apr=nanmean(apr);may=data(5:12:end,:);may=nanmean(may);
jun=data(6:12:end,:);jun=nanmean(jun);jul=data(7:12:end,:);jul=nanmean(jul);aug=data(8:12:end,:);aug=nanmean(aug);
sep=data(9:12:end,:);sep=nanmean(sep);oct=data(10:12:end,:);oct=nanmean(oct);nov=data(11:12:end,:);nov=nanmean(nov);
dec=data(12:12:end,:);dec=nanmean(dec);tclim=[jan;feb;mar;apr;may;jun;jul;aug;sep;oct;nov;dec];clim=tclim;tclim=repmat(tclim,23,1);
ssta=data-tclim;
%%%%%%%%
%for seas anom
amean=nanmean(clim);amean=repmat(amean,12,1);
sanom=clim-amean;
%%%%%%%%%%%%%%%%
clf
%fig1=figure;set(fig1,'position',[1 1 1100 500]);
%%%%%%%%%%%%%%%%%%%%%%%%
h=plot(ctime,sanom);set(h,'LineStyle','-','linewidth',4,'color','k');hold on;set(gca,'TickDir','out');set(gca,'XMinorTick','off','YMinorTick','on')
%h=plot(ctime,amean);set(h,'LineStyle','-','linewidth',4,'color','r'); 
%legend('seas anom','annual mean','orientation','horiz','location','northwest');
h=hline(0,'--k');set(h,'linewidth',2,'color',grey);grid on;

annmean=sprintf('%0.2f',amean(1,1));str1=['annual mean',' ','=',' ', num2str(annmean)]; 
h=text(7,2.2,str1);set(h,'fontname','times new roman','fontsize',22,'fontweight','bold','color','r');
h=text(11,2.25,'^{o}C');set(h,'fontname','times new roman','fontsize',20,'fontweight','bold','color','r');

set(gca,'XColor','k','YColor','k','linewidth',0.6,'FontWeight','normal','fontsize',12,'FontName','times new roman')
set(gca,'xlim',[1 12]);set(gca,'xtick',[1:1:12]);set(gca,'xticklabel',[]);set(gca,'fontname','times new roman','fontsize',18);
set(gca,'XTickLabel',{'Jan';'Feb';'Mar';'Apr';'May';'Jun';'Jul';'Aug';'Sep';'Oct';'Nov';'Dec'},'fontname','times new roman','fontsize',18);
ylabel('SST (^{o}C)','color','k','fontname','times new roman','fontsize',18);

set(gca,'ylim',[-2.5 2.5]); set(gca,'ytick',[-2:1:2]); set(gca,'yticklabel',[-2:1:2]);
h=text(1.5,2.2,'Seas Anom');set(h,'fontname','times new roman','fontsize',22,'fontweight','bold');
set(gca,'ticklength',0.8*get(gca,'ticklength'));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
eval(['print -dtiff ''' outfile 'Fig_SST_AnnualMean_IntAnom_TimeSeries'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

