% Set amplitude A and Love number combination 1+k2-h2

A=24.2334/100; % units m
Lovenumbercombo=0.693;

% Create one-dimensional vectors of latitude and longitude values:

latsvector=-90:1:90;
lonsvector=0:1:359;

% Create two-dimensional arrays of latitude and longitude values:

[lonsarray,latsarray]=meshgrid(lonsvector,latsvector);

% Compute and plot equilibrium tide for omega*t=0.
% Note that "cosd" is the matlab cosine function for an argument measured in degrees
% For input arguments in radians, use "cos"

% Set latitudinal dependence:

latsdependence=cosd(latsarray).^2;

% Set longitudinal dependence:

lonsdependence=2;

equilibriumtide=A*Lovenumbercombo*latsdependence.*cosd(0+lonsdependence*lonsarray);

figure(1)
subplot(2,1,1)
set(gca,'fontsize',18);
hp=pcolor(lonsarray,latsarray,equilibriumtide);
set(hp,'EdgeColor','none');
colorbar('fontsize',18);
hold on
basemap(-90,180,0,360,'k-')
title('Snapshot of M2 equilibrium tide in m')

% Compute and plot equilibrium tide for omega*t=180 degrees

clear equilibriumtide
equilibriumtide=A*Lovenumbercombo*latsdependence.*cosd(180+lonsdependence*lonsarray);

figure(1)
subplot(2,1,2)
set(gca,'fontsize',18);
hp=pcolor(lonsarray,latsarray,equilibriumtide);
set(hp,'EdgeColor','none');
colorbar('fontsize',18);
hold on
basemap(-90,180,0,360,'k-')
title('Snapshot of M2 equilibrium tide in m, 180 degrees later')

xlabel('Longitude (degrees)')
ylabel('Latitude (degrees)')

orient tall
print -dpng equilibriumtideM2.png



