% Load GOT99 data:

load GOT99_M2andK1.mat

% Plot global snapshots of K1 sea surface height 180 degrees apart in phase:

etak1=ampk1.*cosd(0-phasek1); % tidal elevation=amp*cos(0-phase)
figure(1)
subplot(2,1,1)
set(gca,'fontsize',18);
hp=pcolor(lons,lats,etak1);
set(hp,'EdgeColor','none');
set(gca,'Clim',[-0.5 0.5]); % set limits from -0.5 --> 0.5 meters
colorbar('fontsize',18);
title('Snapshot of K1 surface tidal elevation (m)')

clear etak1
etak1=ampk1.*cosd(180-phasek1); % tidal elevation=amp*cos(180-phase)
figure(1)
subplot(2,1,2)
set(gca,'fontsize',18);
hp=pcolor(lons,lats,etak1);
set(hp,'EdgeColor','none');
set(gca,'Clim',[-0.5 0.5]); % set limits from -0.5 --> 0.5 meters
colorbar('fontsize',18);
title('Snapshot of K1 surface tidal elevation (m), 180 degrees later')

xlabel('Longitude (degrees)')
ylabel('Latitude (degrees)')

