% Load GOT99 data:

load GOT99_M2andK1.mat

% Plot global snapshots of M2 sea surface height 180 degrees apart in phase:

etam2=ampm2.*cosd(0-phasem2); % tidal elevation=amp*cos(0-phase)
figure(1)
subplot(2,1,1)
set(gca,'fontsize',18);
hp=pcolor(lons,lats,etam2);
set(hp,'EdgeColor','none');
set(gca,'Clim',[-1 1]); % set limits from -1 --> 1 meters
colorbar('fontsize',18);
title('Snapshot of M2 surface tidal elevation (m)')

clear etam2
etam2=ampm2.*cosd(180-phasem2); % tidal elevation=amp*cos(180-phase)
figure(1)
subplot(2,1,2)
set(gca,'fontsize',18);
hp=pcolor(lons,lats,etam2);
set(hp,'EdgeColor','none');
set(gca,'Clim',[-1 1]); % set limits from -1 --> 1 meters
colorbar('fontsize',18);
title('Snapshot of M2 surface tidal elevation (m), 180 degrees later')

xlabel('Longitude (degrees)')
ylabel('Latitude (degrees)')

