%plot seasonal anomalies
addpath(genpath('C:\Users\enyad\Documents\MATLAB\mytoolbox'));%for Hp laptop
cd 'C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
clear;clc;
path1='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
outfile='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
%%%%%%%%%%%
grey=[0.8 0.8 0.8];ctime=1:12;
%%%%%%%%
olon=load([path1 'aviso.atl.sla.h.lon.dat']);olat=load([path1 'aviso.atl.sla.h.lat.dat']);
tjan=load([path1 'aviso.atl.sla.h.Jan2015.dat']);
taug=load([path1 'aviso.atl.sla.h.Aug2015.dat']);
%%%%%%%%%%%%
%for int anom
data=load([path1 'aviso.atl.sla.h.nwgog.Jan93Dec15.TimeSeries.dat']);data=data(:,3:end);
jan=data(1:12:end,:);jan=nanmean(jan);feb=data(2:12:end,:);feb=nanmean(feb);
mar=data(3:12:end,:);mar=nanmean(mar);apr=data(4:12:end,:);apr=nanmean(apr);may=data(5:12:end,:);may=nanmean(may);
jun=data(6:12:end,:);jun=nanmean(jun);jul=data(7:12:end,:);jul=nanmean(jul);aug=data(8:12:end,:);aug=nanmean(aug);
sep=data(9:12:end,:);sep=nanmean(sep);oct=data(10:12:end,:);oct=nanmean(oct);nov=data(11:12:end,:);nov=nanmean(nov);
dec=data(12:12:end,:);dec=nanmean(dec);tclim=[jan;feb;mar;apr;may;jun;jul;aug;sep;oct;nov;dec];clim=tclim;tclim=repmat(tclim,23,1);
ssta=data-tclim;
%%%%%%%%
%for seas anom
amean=nanmean(clim);amean=repmat(amean,12,1);
sanom=clim-amean;
%%%%%%%%%%%%%%%%
clf
%fig1=figure;set(fig1,'position',[1 1 700 500]);
%%%%%%%%%%%%%%%%%%%%%%%%
%plot spatial maps
h=subplot(2,2,1);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(olon,olat,tjan);shading interp;caxis([-0.15 0.15]);fillmap(grey);

set(gca,'xlim',[-60 20]);set(gca,'xtick',[-60:10:20]);set(gca,'xticklabel',[-60:10:20]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-20 20]);set(gca,'ytick',[-20:10:20]);set(gca,'yticklabel',[-20:10:20]);
h=text(0,15,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   

h=boxx(-10,4,3,7,'--w');set(h,'linewidth',2.0);
h=text(-60,-17,'(a)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%
h=subplot(2,2,2);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(olon,olat,taug);shading interp;caxis([-0.15 0.15]);fillmap(grey);

set(gca,'xlim',[-60 20]);set(gca,'xtick',[-60:10:20]);set(gca,'xticklabel',[-60:10:20]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-20 20]);set(gca,'ytick',[-20:10:20]);set(gca,'yticklabel',[-20:10:20]);
h=text(0,15,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   

pos=get(gca,'pos');h=colorbar('position',[pos(1)*1.68 pos(2) pos(3)*0.05 pos(4)]);set(h,'fontname','times new roman','fontsize',10);
h=text(-60,-17,'(b)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%plot seasonal anomalies time series
h=subplot(2,2,[3 4]);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.04;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.04; set(h, 'position', p);
h=plot(ctime,sanom);set(h,'LineStyle','-','linewidth',4,'color','k');hold on;set(gca,'TickDir','out');set(gca,'XMinorTick','off','YMinorTick','on')
h=hline(0,'--k');set(h,'linewidth',2,'color',grey);grid on;

annmean=sprintf('%0.2f',amean(1,1));str1=['annual mean',' ','=',' ', num2str(annmean)]; 
h=text(4.5,0.045,str1);set(h,'fontname','times new roman','fontsize',18,'fontweight','bold','color','r');
h=text(10.65,2.25,'^{o}C');set(h,'fontname','times new roman','fontsize',18,'fontweight','bold','color','r');

set(gca,'XColor','k','YColor','k','linewidth',0.6,'FontWeight','normal','fontsize',14,'FontName','times new roman')
set(gca,'xlim',[1 12]);set(gca,'xtick',[1:1:12]);set(gca,'xticklabel',[]);set(gca,'fontname','times new roman','fontsize',14);
set(gca,'XTickLabel',{'Jan';'Feb';'Mar';'Apr';'May';'Jun';'Jul';'Aug';'Sep';'Oct';'Nov';'Dec'},'fontname','times new roman','fontsize',14);
ylabel('SLA (m)','color','k','fontname','times new roman','fontsize',14);

set(gca,'ylim',[-0.06 0.06]); set(gca,'ytick',[-0.06:0.02:0.06]); set(gca,'yticklabel',[-0.06:0.02:0.06]);
h=text(1.5,0.05,'Seas Anom');set(h,'fontname','times new roman','fontsize',18,'fontweight','bold');
set(gca,'ticklength',0.8*get(gca,'ticklength'));
h=text(1,-0.05,'(c)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
colormap(jet(30));%colormap(bluewhitered);
eval(['print -dtiff ''' outfile 'Fig_SSH_AnnualMean_SeasAnom_TimeSeries'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%examine SSH changes/trends
data=load([path1 'aviso.atl.sla.h.nwgog.Jan93Dec15.TimeSeries.dat']);ssh=data(:,3:end);
detrend_sdata=detrend(ssh);trend=ssh-detrend_sdata;ssht=trend;
time=1:276;grey=[0.5,0.5,0.5];

%fig1=figure;set(fig1,'position',[1 1 1100 500]);
%%%%%%%%%%%%%%%
h=subplot(1,1,1);p = get(h, 'position');p(1)=p(1)-0.04;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.06; set(h, 'position', p);p(4) = p(4) + 0.04; set(h, 'position', p);
plot(time,ssh,'-k','linewidth',3);hold on;plot(time,ssht,':r','linewidth',4.5);

set(gca,'ylim',[-0.15 0.15]); set(gca,'ytick',[-0.2:0.05:0.2]); set(gca,'yticklabel',[-0.2:0.05:0.2]);set(gca,'TickDir','out');set(gca,'yminortick','on');
set(gca,'xlim',[1 276]);set(gca,'xtick',[1:12:276]);set(gca,'xticklabel',[1993:2015]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'xminortick','on');
%set(gca,'XTickLabel',{'1900';' ';'20';' ';'40';' ';'60';' ';'80';' ';'2000';' ';'20';},'fontname','times new roman','fontsize',10);

h=hline(0,'-k');set(h,'LineStyle','--','linewidth',2,'color','b');set(gca,'ticklength',1.25*get(gca,'ticklength'));
ylabel('SLA (m)','color','k','fontname','times new roman','fontsize',14);

set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
eval(['print -dtiff ''' outfile 'Fig_SSH_TimeSeries_Trend'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


