%plot seasonal anomalies
addpath(genpath('C:\Users\enyad\Documents\MATLAB\mytoolbox'));%for Hp laptop
cd 'C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
clear;clc;
path1='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
outfile='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
%%%%%%%%%%%
grey=[0.8 0.8 0.8];ctime=1:12;
%%%%%%%%
olon=load([path1 'ostia.atl.sst.lon.dat']);olat=load([path1 'ostia.atl.sst.lat.dat']);
tjan=load([path1 'ostia.atl.sst.mean.Jan.dat']);
taug=load([path1 'ostia.atl.sst.mean.Aug.dat']);
%%%%%%%%%%%%
%for int anom
data=load([path1 'ostia.atl.sst.nwgog.Jan93Dec15.TimeSeries.dat']);data=data(:,3:end);
jan=data(1:12:end,:);jan=nanmean(jan);feb=data(2:12:end,:);feb=nanmean(feb);
mar=data(3:12:end,:);mar=nanmean(mar);apr=data(4:12:end,:);apr=nanmean(apr);may=data(5:12:end,:);may=nanmean(may);
jun=data(6:12:end,:);jun=nanmean(jun);jul=data(7:12:end,:);jul=nanmean(jul);aug=data(8:12:end,:);aug=nanmean(aug);
sep=data(9:12:end,:);sep=nanmean(sep);oct=data(10:12:end,:);oct=nanmean(oct);nov=data(11:12:end,:);nov=nanmean(nov);
dec=data(12:12:end,:);dec=nanmean(dec);tclim=[jan;feb;mar;apr;may;jun;jul;aug;sep;oct;nov;dec];clim=tclim;tclim=repmat(tclim,23,1);
ssta=data-tclim;
%%%%%%%%
%for seas anom
amean=nanmean(clim);amean=repmat(amean,12,1);
sanom=clim-amean;
%%%%%%%%%%%%%%%%
clf
%fig1=figure;set(fig1,'position',[1 1 700 500]);
%%%%%%%%%%%%%%%%%%%%%%%%
%examine SST changes/trends
%data=load([path1 'ostia.atl.sst.nwgog.Jan93Dec15.TimeSeries.dat']);sst=data(:,3:end);
detrend_sdata=detrend(ssta);trend=ssta-detrend_sdata;sstt=trend;

ssta=moving(ssta,3);ssta=moving(ssta,3);

%fig1=figure;set(fig1,'position',[1 1 1100 500]);
time=1:276;grey=[0.5,0.5,0.5];
%%%%%%%%%%%%%%%
h=subplot(1,1,1);p = get(h, 'position');p(1)=p(1)-0.04;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.06; set(h, 'position', p);p(4) = p(4) + 0.04; set(h, 'position', p);
plot(time,ssta,'-k','linewidth',3);hold on;plot(time,sstt,':r','linewidth',4.5);

set(gca,'ylim',[-1 1]); set(gca,'ytick',[-1:0.5:1]); set(gca,'yticklabel',[-1:0.5:1]);set(gca,'TickDir','out');set(gca,'yminortick','on');
set(gca,'xlim',[1 276]);set(gca,'xtick',[1:12:276]);set(gca,'xticklabel',[1993:2015]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'xminortick','on');
%set(gca,'XTickLabel',{'1900';' ';'20';' ';'40';' ';'60';' ';'80';' ';'2000';' ';'20';},'fontname','times new roman','fontsize',10);

h=hline(0,'-k');set(h,'LineStyle','--','linewidth',2,'color','b');set(gca,'ticklength',1.25*get(gca,'ticklength'));
ylabel('SST (^{o}C)','color','k','fontname','times new roman','fontsize',14);

set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
eval(['print -dtiff ''' outfile 'Fig_SST_TimeSeries_Trend'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


