%plot seasonal anomalies
addpath(genpath('C:\Users\enyad\Documents\MATLAB\mytoolbox'));%for Hp laptop
cd 'C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
clear;clc;
path1='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
outfile='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
%%%%%%%%%%%
grey=[0.8 0.8 0.8];ctime=1:12;scale=3;
%%%%%%%%
%wind spd in m/s
clon=load([path1 'ccmp.Atl.lon.dat']);clat=load([path1 'ccmp.Atl.lat.dat']);
ujan=load([path1 'ccmp.Atl.uwind.Jan2015.dat']);vjan=load([path1 'ccmp.Atl.vwind.Jan2015.dat']);
uaug=load([path1 'ccmp.Atl.uwind.Aug2015.dat']);vaug=load([path1 'ccmp.Atl.vwind.Aug2015.dat']);

olon=load([path1 'oscar.Atl.lon.dat']);olat=load([path1 'oscar.Atl.lat.dat']);
ujanc=load([path1 'oscar.Atl.ucur.Jan2015.dat']);vjanc=load([path1 'oscar.Atl.vcur.Jan2015.dat']);
uaugc=load([path1 'oscar.Atl.ucur.Aug2015.dat']);vaugc=load([path1 'oscar.Atl.vcur.Aug2015.dat']);
%%%%%%%%%%%%%%%%
clf
%fig1=figure;set(fig1,'position',[1 1 700 500]);
%%%%%%%%%%%%%%%%%%%%%%%%
%plot spatial maps
h=subplot(2,2,1);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(clon(1:20:end),clat(1:20:end),ujan(1:20:end,1:20:end),vjan(1:20:end,1:20:end),scale,'k','LineWidth',2);fillmap(grey);

set(gca,'xlim',[-60 20]);set(gca,'xtick',[-60:10:20]);set(gca,'xticklabel',[-60:10:20]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-20 20]);set(gca,'ytick',[-20:10:20]);set(gca,'yticklabel',[-20:10:20]);
h=text(0,15,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   

%h=boxx(-10,4,3,7,'--w');set(h,'linewidth',2.0);
h=text(-60,-17,'(a)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%
h=subplot(2,2,2);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(clon(1:20:end),clat(1:20:end),uaug(1:20:end,1:20:end),vaug(1:20:end,1:20:end),scale,'k','LineWidth',2);fillmap(grey);

set(gca,'xlim',[-60 20]);set(gca,'xtick',[-60:10:20]);set(gca,'xticklabel',[-60:10:20]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-20 20]);set(gca,'ytick',[-20:10:20]);set(gca,'yticklabel',[-20:10:20]);
h=text(0,15,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');
h=text(-60,-17,'(b)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%plot currents
h=subplot(2,2,3);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(olon(1:5:end),olat(1:5:end),ujanc(1:5:end,1:5:end),vjanc(1:5:end,1:5:end),scale,'k','LineWidth',2);fillmap(grey);

set(gca,'xlim',[-60 20]);set(gca,'xtick',[-60:10:20]);set(gca,'xticklabel',[-60:10:20]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-20 20]);set(gca,'ytick',[-20:10:20]);set(gca,'yticklabel',[-20:10:20]);
h=text(0,15,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(-60,-17,'(c)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%
h=subplot(2,2,4);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(olon(1:5:end),olat(1:5:end),uaugc(1:5:end,1:5:end),vaugc(1:5:end,1:5:end),scale,'k','LineWidth',2);fillmap(grey);

set(gca,'xlim',[-60 20]);set(gca,'xtick',[-60:10:20]);set(gca,'xticklabel',[-60:10:20]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-20 20]);set(gca,'ytick',[-20:10:20]);set(gca,'yticklabel',[-20:10:20]);
h=text(0,15,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(-60,-17,'(d)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
colormap(jet(30));%colormap(bluewhitered);
eval(['print -dtiff ''' outfile 'Fig_Winds_Currents_SeasAnom'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
