%plot seasonal anomalies
addpath(genpath('C:\Users\enyad\Documents\MATLAB\mytoolbox'));%for Hp laptop
cd 'C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
clear;clc;
path1='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
outfile='C:\Users\enyad\Documents\NRL\SummerSch\UG2018\lab\SatLabEx\';
%%%%%%%%%%%
grey=[0.8 0.8 0.8];ctime=1:12;scale=2;
%%%%%%%%
%wind spd in m/s
clon=load([path1 'ccmp.IO.lon.dat']);clat=load([path1 'ccmp.IO.lat.dat']);
ujan=load([path1 'ccmp.IO.uwind.Jan2015.dat']);vjan=load([path1 'ccmp.IO.vwind.Jan2015.dat']);
uaug=load([path1 'ccmp.IO.uwind.Aug2015.dat']);vaug=load([path1 'ccmp.IO.vwind.Aug2015.dat']);

olon=load([path1 'oscar.IO.lon.dat']);olat=load([path1 'oscar.IO.lat.dat']);
ujanc=load([path1 'oscar.IO.ucur.Jan2015.dat']);vjanc=load([path1 'oscar.IO.vcur.Jan2015.dat']);
uaugc=load([path1 'oscar.IO.ucur.Aug2015.dat']);vaugc=load([path1 'oscar.IO.vcur.Aug2015.dat']);
%%%%%%%%%%%%%%%%
clf
%fig1=figure;set(fig1,'position',[1 1 700 500]);
%%%%%%%%%%%%%%%%%%%%%%%%
%plot spatial maps
h=subplot(2,2,1);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(clon(1:25:end),clat(1:25:end),ujan(1:25:end,1:25:end),vjan(1:25:end,1:25:end),scale,'k','LineWidth',1.5);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   

%h=boxx(-10,4,3,7,'--w');set(h,'linewidth',2.0);
h=text(22,15,'(a)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%
h=subplot(2,2,2);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(clon(1:25:end),clat(1:25:end),uaug(1:25:end,1:25:end),vaug(1:25:end,1:25:end),scale,'k','LineWidth',1.5);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');
h=text(22,15,'(b)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%plot currents
h=subplot(2,2,3);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(olon(1:5:end),olat(1:5:end),ujanc(1:5:end,1:5:end),vjanc(1:5:end,1:5:end),scale,'k','LineWidth',1.5);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(22,15,'(c)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%
h=subplot(2,2,4);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
quiver(olon(1:5:end),olat(1:5:end),uaugc(1:5:end,1:5:end),vaugc(1:5:end,1:5:end),scale,'k','LineWidth',1.5);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(22,15,'(d)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
colormap(jet(30));%colormap(bluewhitered);
eval(['print -dtiff ''' outfile 'Fig_IndianOcean_Winds_Currents_Vectors'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%plot zonal wind and currents
h=subplot(2,2,1);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(clon,clat,ujan);shading interp;caxis([-10 10]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   

%h=boxx(-10,4,3,7,'--w');set(h,'linewidth',2.0);
h=text(22,15,'(a)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%
h=subplot(2,2,2);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(clon,clat,uaug);shading interp;caxis([-10 10]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');
h=text(22,15,'(b)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
pos=get(gca,'pos');h=colorbar('position',[pos(1)*1.68 pos(2) pos(3)*0.05 pos(4)]);set(h,'fontname','times new roman','fontsize',10);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%plot currents
h=subplot(2,2,3);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(olon,olat,ujanc);shading interp;caxis([-0.5 0.5]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(22,15,'(c)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%
h=subplot(2,2,4);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(olon,olat,uaugc);shading interp;caxis([-0.5 0.5]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(22,15,'(d)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
pos=get(gca,'pos');h=colorbar('position',[pos(1)*1.68 pos(2) pos(3)*0.05 pos(4)]);set(h,'fontname','times new roman','fontsize',10);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
colormap(jet(30));%colormap(bluewhitered);
eval(['print -dtiff ''' outfile 'Fig_IndianOcean_Winds_Currents_ZonalColor'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%plot meridional winds and currents
h=subplot(2,2,1);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(clon,clat,vjan);shading interp;caxis([-10 10]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   

%h=boxx(-10,4,3,7,'--w');set(h,'linewidth',2.0);
h=text(22,15,'(a)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%%%
h=subplot(2,2,2);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(clon,clat,vaug);shading interp;caxis([-10 10]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');
h=text(22,15,'(b)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
pos=get(gca,'pos');h=colorbar('position',[pos(1)*1.68 pos(2) pos(3)*0.05 pos(4)]);set(h,'fontname','times new roman','fontsize',10);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%plot currents
h=subplot(2,2,3);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(olon,olat,vjanc);shading interp;caxis([-0.5 0.5]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Jan');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(22,15,'(c)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
%%%%%%%%%%%%%
h=subplot(2,2,4);p = get(h, 'position');p(1)=p(1)-0.02;set(h, 'position', p);p(2)=p(2)-0.02;set(h, 'position', p);p(3) = p(3) + 0.03; set(h, 'position', p);p(4) = p(4) + 0.06; set(h, 'position', p);
pcolor(olon,olat,vaugc);shading interp;caxis([-0.5 0.5]);fillmap(grey);

set(gca,'xlim',[20 120]);set(gca,'xtick',[20:20:120]);set(gca,'xticklabel',[20:20:120]);set(gca,'fontname','times new roman','fontsize',14);set(gca,'TickDir','out'); 
set(gca,'ylim',[-30 30]);set(gca,'ytick',[-30:10:30]);set(gca,'yticklabel',[-30:10:30]);
h=text(22,5,'Aug');set(h,'fontname','times new roman','fontsize',20,'color','k','fontweight','bold');   
h=text(22,15,'(d)');set(h,'fontname','times new roman','fontsize',14,'color','black','fontweight','bold');
pos=get(gca,'pos');h=colorbar('position',[pos(1)*1.68 pos(2) pos(3)*0.05 pos(4)]);set(h,'fontname','times new roman','fontsize',10);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'PaperPositionMode','auto');set(gcf, 'Color', 'w');
colormap(jet(30));%colormap(bluewhitered);
eval(['print -dtiff ''' outfile 'Fig_IndianOcean_Winds_Currents_MeridColor'' -painters']);
%export_fig Fig_SST_AnnualMean_IntAnom_TimeSeries.tiff -m2 -nocrop -a2 -painters;%-zbuffer;%magnify the image;antiliasing (1-4)1 is no anti-liasing, 4is max default is 3
disp('Finished!!');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
