function WL=load_Takoradi(infile);
fid=fopen(infile)
fmt='%f %f %f %f %f';
M=textscan(fid,fmt,'delimiter',',');
M=cell2mat(M);
[m,n]=size(M);
D=datenum([M(:,1:4) zeros(m,2)]);
k=find(M(:,5)<-1000); % index of bad data
M(k,5)=NaN; % Set bad data to not a number
ht=M(:,5);
ht=ht*1e-3;
WL.Variables.Name{1}='Datenum';
WL.Variables.Name{2}='Year';
WL.Variables.Name{3}='Month';
WL.Variables.Name{4}='Day';
WL.Variables.Name{5}='Hour';
WL.Variables.Name{6}='Minute';
WL.Variables.Name{7}='Second';
WL.Variables.Name{8}='Water Level';
WL.Variables.Name{9}='Latitude';
WL.Variables.Name{10}='Longitude';
WL.Variables.Value{1}=D;
WL.Variables.Value{2}=M(:,1);
WL.Variables.Value{3}=M(:,2);
WL.Variables.Value{4}=M(:,3);
WL.Variables.Value{5}=M(:,4);
WL.Variables.Value{6}=M(:,5);
WL.Variables.Value{7}=zeros(m,2);
WL.Variables.Value{8}=ht;
WL.Variables.Value{9}=4.884556;
WL.Variables.Value{10}=-1.745028; 
WL.Variables.Units{1}='Datenum';
WL.Variables.Units{2}='Year UTC';
WL.Variables.Units{3}='Month UTC';
WL.Variables.Units{4}='Day UTC';
WL.Variables.Units{5}='Hour UTC';
WL.Variables.Units{6}='Minute UTC';
WL.Variables.Units{7}='Second UTC';
WL.Variables.Units{8}='m';
WL.Variables.Units{9}='degrees N';
WL.Variables.Units{10}='degrees E';