%% Cell 1 load Takoradi Data
WL1=load_Takoradi('h231c.csv');

 %% Cell 2 Plot Takoradi Data
 figure
 %plot(D,ht)
 plot(WL1.Variables.Value{1},WL1.Variables.Value{8});
 datetick('x','mm/yy')
 ylabel('Sea Surface Height (m)')
 title('Takoradi Tides')
 print -djpeg90 takoradi_tides
 %% Cell 3 Run harmonic Analysis of Takoradi Data
interval=1; % hrs   
%[name,freq,tidecon,xout]=t_tide(ht,'interval',.1,'start_time',start_time,lat);
coef=ut_solv(WL1.Variables.Value{1},WL1.Variables.Value{8},[],WL1.Variables.Value{9},'auto','notrend');
%% Cell 4 Using the harmonic fit, create the hamonically generated water level time series 
% at Takoradi over the observation time. Create a jpeg file of the plot
[ht_fit]=ut_reconstr(WL1.Variables.Value{1},coef);
hold on
plot(WL1.Variables.Value{1},ht_fit,'r-')
print -djpeg90 takoradi_tides_pred
%% Cell 5 Zoon in on the Takoradi Data. Create a jpeg file of the plot
x =[724429.802444965 724434.890963673];
figure
keep=find(WL1.Variables.Value{1}>=x(1) & WL1.Variables.Value{1}<=x(2));
plot(WL1.Variables.Value{1}(keep),WL1.Variables.Value{8}(keep)); hold on
plot(WL1.Variables.Value{1}(keep),ht_fit(keep),'r')
A=axis;axis([x A(3:4)]);
datetick('x','mm/yy')
ylabel('Sea Surface Height (m)')
title('Takoradi Tides')
print -djpeg90 takoradi_tides_pred_zoom
%% Cell 6 Load in the data from the tide gauge deployed at Tema
WL2=load_insitu_str('COESSING2018_2018-08-02_11-24-07-617.csv',77,36);
%% Cell 7 Use the harmonic fit from Takoradi to predict the tide at Takoradi
% over the same time period as the dat acollected at Tema
[ht_fit2]=ut_reconstr(WL2.Variables.Value{1},coef);
%% Cell 8 Plot Tema data
ftema=figure;
p1=plot(WL2.Variables.Value{1},WL2.Variables.Value{14})
datetick('x','mm/dd')
ylabel('Sea Surface Height (m)')
title('Tema Tides')
print -djpeg90 tema_tides
%% Cell 9 Plot Takoradi prediction over the same period as the observed tema data
% Turn hold n so that the Takarodi prediction can be plotted as well
hold on
p2=plot(WL2.Variables.Value{1},ht_fit2,'r');
%% Cell 10 Remove the means of each time series and replot
ftema_nomean=figure;
p1=plot(WL2.Variables.Value{1},WL2.Variables.Value{14}-mean(WL2.Variables.Value{14}))
hold on
p2=plot(WL2.Variables.Value{1},ht_fit2-mean(ht_fit2),'r');

datetick('x','mm/dd')
ylabel('Sea Surface Height Mean Removed (m)')
title('Tema Tides & Takoradi Predicted')
print -djpeg90 tema_Tako_pred

