#!/usr/bin/env python
# coding: utf-8

# ## Exercise 1:  Let's change some of the visual aspects of the plot
# 
# - a) Copy and paste the previous cell of code where we plotted the fancy map.
# - b) Change the title to "Sea Surface Temperature". Re-evaluate the cell to check that it worked!
# - c) Change the title fontsize to 24. Re-evaluate the cell.
# - d) Move the colorbar to the bottom of the figure by replacing the word 'Right' with 'Bottom'. Re-evaluate.
# - e) See if you can figure out how to get rid of the parallel and meridian lines. Re-evaluate.
# - f) Change the color of the continents to red by adding "color='r'". Re-evaluate.
# - g) Now see if you can figure out how to change the color of the continents to black, by looking at the pdf with the list of colors. Re-evaluate
# - h) Change the size of the figure so that it is 3 inches tall. Re-evaluate.

# In[1]:


get_ipython().run_line_magic('matplotlib', 'inline')
import matplotlib.pyplot as plt
import numpy as np
from netCDF4 import Dataset
from mpl_toolkits.basemap import Basemap


# # Load data

# In[2]:


# This is the path to where your data is stored on your computer
datadir = '/Users/paigemar/Documents/COESSING2019/COESSING2018_folder/SATELLITE_DATA/'
data = Dataset(datadir+'02Aug2018.0.nc') # Loads data!


# In[3]:


# Print the names of all of the variables in "data"
print(data.variables.keys())


# # Define variables

# In[4]:


sst = data.variables['sea_surface_temperature']
lon = data.variables['lon']
lat = data.variables['lat']
print(sst) # this prints out all metadata associated with the sst variable (units, variable shape, etc.)


# # Convert from Kelvin to Celsius

# In[5]:


sst_C = sst[:,:,:] - 273.15


# ### Original fancy plot

# In[9]:


plt.figure(figsize=(12,8))

# Make a map of Mercator projection with lat/lon values corresponding to our data
m = Basemap(projection='merc',llcrnrlon=lon[:].min(), 
  urcrnrlon=lon[:].max(),llcrnrlat=lat[:].min(),urcrnrlat=lat[:].max())

# Plot the data similar to above, but using the map instance "m" that we just defined
LON,LAT = m(*np.meshgrid(lon,lat)) 
m.pcolormesh(LON,LAT,sst_C[0,:,:]) 
m.colorbar(location='right',label='Degrees Celsius')
plt.title('SST on 02 August 2018',fontsize=18)

# Add map features
m.drawcoastlines() # draws outline of the continental coasts
m.fillcontinents() # fills continents with default grey color
m.drawparallels(np.arange(-90.,90.,30.),labels=[1,0,0,0]) # draws lines of latitude
m.drawmeridians(np.arange(-180.,180.,60.),labels=[0,0,0,1]) # draws lines of longitude

plt.savefig('SST_Basemap.png')


# # Exercise 1 solution

# In[7]:


plt.figure(figsize=(12,3))

# Make a map of Mercator projection with lat/lon values corresponding to our data
m = Basemap(projection='merc',llcrnrlon=lon[:].min(), 
  urcrnrlon=lon[:].max(),llcrnrlat=lat[:].min(),urcrnrlat=lat[:].max())

# Plot the data similar to above, but using the map instance "m" that we just defined
LON,LAT = m(*np.meshgrid(lon,lat)) 
m.pcolormesh(LON,LAT,sst_C[0,:,:]) 
m.colorbar(location='bottom',label='Degrees Celsius')
plt.title('Sea Surface Temperature',fontsize=24)

# Add map features
m.drawcoastlines() # draws outline of the continental coasts
m.fillcontinents(color='k') # fills continents with black color
#m.drawparallels(np.arange(-90.,90.,30.),labels=[1,0,0,0]) # draws lines of latitude
#m.drawmeridians(np.arange(-180.,180.,60.),labels=[0,0,0,1]) # draws lines of longitude


# In[ ]:




