#!/usr/bin/env python
# coding: utf-8

# ## Exercise 2: Different map projection, zoom in on a particular region, and add a marker for RMU!
# 
# - (a) Copy the cell with the fancy plot that we made together (before you did exercise 1).
# - (b) Use a different map projection. So far we have used Mercator, but try another one from the list provided (Some_basemap_projections.pdf)!
#     - Hint: change the map projection name when defining map 'm'
# - (c) Zoom in on the plot so that it only shows the portion of SST near West Africa. 
#     - To do this, you will need to change the lat/lon values when you are setting up the basemap "m".
#     - Use lat/lon values of 8N and 12S for latitude, and 15E and 20W for longitude
#     - Hint: latitude is negative for degrees south, and longitude is negative for degrees west
# - (d) If you want, try inserting different lat/lon values to play with different portion of the map.
# - (d) Add a marker to locate where RMU is located!
#     - You will need to add the following two lines:
#         - x,y = m(-0.063922,5.607551)
#         - m.plot(x,y, marker='D',color='r')
#     - The first line creates a map instance for the longitude and latitude of RMU
#     - The second line plots the marker as a diamond in red on the plot. 
#     - If you want, you can change the shape and color of the marker by changing 'marker' and 'color' (see marker options in matplotlib_markers.pdf and color options in pyplot_colors.png)

# In[1]:


get_ipython().run_line_magic('matplotlib', 'inline')
import matplotlib.pyplot as plt
import numpy as np
from netCDF4 import Dataset
from mpl_toolkits.basemap import Basemap


# # Load data

# In[2]:


# This is the path to where your data is stored on your computer
datadir = '/Users/paigemar/Documents/COESSING2019/COESSING2018_folder/SATELLITE_DATA/'
data = Dataset(datadir+'02Aug2018.0.nc') # Loads data!


# In[3]:


# Print the names of all of the variables in "data"
print(data.variables.keys())


# # Define variables

# In[4]:


sst = data.variables['sea_surface_temperature']
lon = data.variables['lon']
lat = data.variables['lat']
print(sst) # this prints out all metadata associated with the sst variable (units, variable shape, etc.)


# # Convert from Kelvin to Celsius

# In[5]:


sst_C = sst[:,:,:] - 273.15


# ### Original plot

# In[13]:


plt.figure(figsize=(12,8))

# Make a map of Mercator projection with lat/lon values corresponding to our data
m = Basemap(projection='merc',llcrnrlon=lon[:].min(), 
  urcrnrlon=lon[:].max(),llcrnrlat=lat[:].min(),urcrnrlat=lat[:].max(),resolution='l')

# Plot the data similar to above, but using the map instance "m" that we just defined
LON,LAT = m(*np.meshgrid(lon,lat)) 
m.pcolormesh(LON,LAT,sst_C[0,:,:]) 
m.colorbar(location='right',label='Degrees Celsius')
plt.title('SST on 02 August 2018',fontsize=18)

# Add map features
m.drawcoastlines() # draws outline of the continental coasts
m.fillcontinents() # fills continents with default grey color
m.drawparallels(np.arange(-90.,90.,30.),labels=[1,0,0,0]) # draws lines of latitude
m.drawmeridians(np.arange(-180.,180.,60.),labels=[0,0,0,1]) # draws lines of longitude


# # Exercise 2 Solution

# In[6]:


plt.figure(figsize=(12,8))

# Make a map of Mercator projection with lat/lon values corresponding to our data
m = Basemap(projection='cyl',llcrnrlon=-20, 
  urcrnrlon=15,llcrnrlat=-12,urcrnrlat=8)

# Plot the data similar to above, but using the map instance "m" that we just defined
LON,LAT = m(*np.meshgrid(lon,lat)) 
m.pcolormesh(LON,LAT,sst_C[0,:,:]) 
m.colorbar(location='right',label='Degrees Celsius')
plt.title('SST on 02 August 2018',fontsize=18)

# Add map features
m.drawcoastlines() # draws outline of the continental coasts
m.fillcontinents() # fills continents with default grey color
m.drawparallels(np.arange(-90.,90.,30.),labels=[1,0,0,0]) # draws lines of latitude
m.drawmeridians(np.arange(-180.,180.,60.),labels=[0,0,0,1]) # draws lines of longitude

x,y = m(-0.063922,5.607551)
m.plot(x,y, marker='D',color='r')


# In[ ]:




