#!/usr/bin/env python
# coding: utf-8

# ## Exercise 3: Plot the wind speed
# 
# - (a) For this exercise, start a new script by creating a copy of this script. You can do this by clicking on the "File" menu and choosing "Make a Copy..." This will open up a new notebook that is identical to the current one!
# - (b) We want to plot a different variable - the wind speed! Look at the output from the line "data.variables.keys()" to find out what the variable is called for wind speed, and load the variable by replacing the sea surface temperature variable.
# - (c) What units does the wind speed variable have?
#     - Hint: use the print() function to find out!
# - (d) Go through the next couple cells of the script and determine if they should remain or if they should be removed for the wind speed variable.
# - (e) Plot the wind speed!
# - (f) Change the colormap for the wind speed - choose from the list provided (pyplot_colormap_options.pdf)!
#     - Hint: you can do this by adding an argument in the pcolormesh() function. You will type 'cmap=[name of colormap]'

# ### This script is a copy of the lab notebook script, and we will mostly reuse the code, except that we will plot another variable!

# In[1]:


get_ipython().run_line_magic('matplotlib', 'inline')
import matplotlib.pyplot as plt
import numpy as np
from netCDF4 import Dataset
from mpl_toolkits.basemap import Basemap


# # Load data

# In[2]:


# This is the path to where your data is stored on your computer
datadir = '/Users/paigemar/Documents/COESSING2019/COESSING2018_folder/SATELLITE_DATA/'
data = Dataset(datadir+'02Aug2018.0.nc') # Loads data!


# In[3]:


# Print the names of all of the variables in "data"
print(data.variables.keys())


# # Define variables

# In[6]:


ws = data.variables['wind_speed']
lon = data.variables['lon']
lat = data.variables['lat']
print(ws) # this prints out all metadata associated with the sst variable (units, variable shape, etc.)


# ### Don't need to convert these units - they are in meters/second

# # Plot the data using Basemap

# In[11]:


plt.figure(figsize=(12,8))

# Make a map of Mercator projection with lat/lon values corresponding to our data
m = Basemap(projection='merc',llcrnrlon=lon[:].min(), 
  urcrnrlon=lon[:].max(),llcrnrlat=lat[:].min(),urcrnrlat=lat[:].max())

# Plot the data similar to above, but using the map instance "m" that we just defined
LON,LAT = m(*np.meshgrid(lon,lat)) 
m.pcolormesh(LON,LAT,ws[0,:,:],cmap='gist_ncar') # Here is where you can insert any colormap you'd like!
m.colorbar(location='right',label='m/s')
plt.title('SST on 02 August 2018',fontsize=18)

# Add map features
m.drawcoastlines() # draws outline of the continental coasts
m.fillcontinents() # fills continents with default grey color
m.drawparallels(np.arange(-90.,90.,30.),labels=[1,0,0,0]) # draws lines of latitude
m.drawmeridians(np.arange(-180.,180.,60.),labels=[0,0,0,1]) # draws lines of longitude

plt.savefig('wind_speed_Basemap.png')


# In[ ]:




