#!/usr/bin/env python
# coding: utf-8

# ## Exercise 4: Plot the anomalous wind speed
# 
# - (a) Copy and paste the plotting cell of the wind speed that you just made.
# - (b) Above this cell, insert an empty code cell (click the '+' sign to create a new cell, then highlight the cell and click the up arrow to move it above the plotting cell.
# - (c) In this cell, take the wind speed variable and subtract off the mean (this will give us the anomalous wind speed).
#     - Hint: use the numpy function np.mean()
# - (d) Plot the anomalous wind speed using pcolormesh(). Try using the cmap called 'bwr', and add the arguments 'vmin=-10' and 'vmax=10'. (These last statements will set the limits on your colorbar.)

# ### This script is a copy of the Exercise 3 notebook script, and we will mostly reuse the code!

# In[1]:


get_ipython().run_line_magic('matplotlib', 'inline')
import matplotlib.pyplot as plt
import numpy as np
from netCDF4 import Dataset
from mpl_toolkits.basemap import Basemap


# # Load data

# In[2]:


# This is the path to where your data is stored on your computer
datadir = 'Sat_data/'
data = Dataset(datadir+'02Aug2018.0.nc') # Loads data!


# In[3]:


# Print the names of all of the variables in "data"
print(data.variables.keys())


# # Define variables

# In[4]:


ws = data.variables['wind_speed']
lon = data.variables['lon']
lat = data.variables['lat']
print(ws) # this prints out all metadata associated with the sst variable (units, variable shape, etc.)


# ### Don't need to convert these units - they are in meters/second

# In[6]:


ws_anom = ws - np.mean(ws)


# # Plot the data using Basemap

# In[7]:


plt.figure(figsize=(12,8))

# Make a map of Mercator projection with lat/lon values corresponding to our data
m = Basemap(projection='merc',llcrnrlon=lon[:].min(), 
  urcrnrlon=lon[:].max(),llcrnrlat=lat[:].min(),urcrnrlat=lat[:].max())

# Plot the data similar to above, but using the map instance "m" that we just defined
LON,LAT = m(*np.meshgrid(lon,lat)) 
m.pcolormesh(LON,LAT,ws_anom[0,:,:],cmap='bwr',vmin=-10,vmax=10) # Here is where you can insert any colormap you'd like!
m.colorbar(location='right',label='m/s')
plt.title('SST on 02 August 2018',fontsize=18)

# Add map features
m.drawcoastlines() # draws outline of the continental coasts
m.fillcontinents() # fills continents with default grey color
m.drawparallels(np.arange(-90.,90.,30.),labels=[1,0,0,0]) # draws lines of latitude
m.drawmeridians(np.arange(-180.,180.,60.),labels=[0,0,0,1]) # draws lines of longitude

#plt.savefig('wind_speed_anomaly.png') # uncomment this to save the figure


# This plot of the wind speed anomaly shows (in red) the areas that are above average and (in blue) the areas that are below average.

# ### I hope you found these Python exercises helpful! If you want to learn more Python and Jupyter Notebook, check the Resources tab on the coessing.org website for some great learning materials, including cheatsheets, interactive websites, and online courses. 

# In[ ]:




